<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <link rel="icon" type="image/x-icon" href="/logo/favicon.ico">
        <link rel="icon" type="image/png" sizes="32x32" href="/logo/favicon-32x32.png">
        <link rel="icon" type="image/png" sizes="16x16" href="/logo/favicon-16x16.png">
        <link rel="apple-touch-icon" sizes="180x180" href="/logo/apple-touch-icon.png">
        <link rel="manifest" href="/logo/site.webmanifest">

        <!-- Preload logo for better performance -->
        <link rel="preload" href="/logo/fabula-ai.png" as="image" type="image/png">

        <title><?php echo e(config('app.name', 'TG-Bet')); ?></title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700" rel="stylesheet" />

        <!-- Scripts -->
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    </head>
    <body class="font-sans antialiased">
        <div id="app"></div>
    </body>
</html>
<?php /**PATH C:\Users\User\Desktop\promo\resources\views/welcome.blade.php ENDPATH**/ ?>