# PowerShell script to start simple development servers
Write-Host "🚀 Starting simple development servers..." -ForegroundColor Green
Write-Host ""

# Server URLs
Write-Host "📋 Server URLs:" -ForegroundColor White
Write-Host "   🌐 Laravel: http://localhost:8000" -ForegroundColor Cyan
Write-Host "   ⚡ Vite: http://localhost:5173" -ForegroundColor Cyan
Write-Host ""

Write-Host "💡 Press Ctrl+C in any window to stop that server" -ForegroundColor Yellow
Write-Host ""

# Start Laravel server
Start-Process powershell -ArgumentList "-NoExit", "-Command", "php artisan serve --port=8000" -WindowStyle Normal

# Wait a bit
Start-Sleep -Seconds 2

# Start Vite dev server
Start-Process powershell -ArgumentList "-NoExit", "-Command", "npm run dev" -WindowStyle Normal

Write-Host "✅ All servers started in separate windows!" -ForegroundColor Green
Write-Host ""
Write-Host "🎉 Development environment is ready!" -ForegroundColor Green
Write-Host "🌐 Open: http://localhost:8000" -ForegroundColor Cyan 