# PowerShell script to start all development servers
Write-Host "🚀 Starting development servers..." -ForegroundColor Green
Write-Host ""

# Check if Soketi is installed
try {
    $soketiVersion = soketi --version 2>$null
    Write-Host "✅ Soketi is installed" -ForegroundColor Green
} catch {
    Write-Host "❌ Soketi is not installed. Please install it first:" -ForegroundColor Red
    Write-Host "npm install -g @soketi/soketi" -ForegroundColor Yellow
    exit 1
}

# Check Node.js version
try {
    $nodeVersion = node --version
    Write-Host "✅ Node.js version: $nodeVersion" -ForegroundColor Green
    
    # Check compatibility
    if ($nodeVersion -match "v(\d+)") {
        $majorVersion = [int]$matches[1]
        if ($majorVersion -ge 19) {
            Write-Host "⚠️  Warning: Your Node.js version might not be compatible with Soketi." -ForegroundColor Yellow
            Write-Host "   Soketi works best with Node.js 14, 16, or 18." -ForegroundColor Yellow
        }
    }
} catch {
    Write-Host "❌ Node.js is not installed" -ForegroundColor Red
    exit 1
}

Write-Host ""
Write-Host "🔄 Starting servers..." -ForegroundColor Cyan
Write-Host ""

# Server URLs
Write-Host "📋 Server URLs:" -ForegroundColor White
Write-Host "   🌐 Laravel: http://localhost:8000" -ForegroundColor Cyan
Write-Host "   ⚡ Vite: http://localhost:5173" -ForegroundColor Cyan
Write-Host "   🔌 Soketi: http://localhost:6001" -ForegroundColor Cyan
Write-Host "   📊 Soketi Dashboard: http://localhost:6001/dashboard" -ForegroundColor Cyan
Write-Host ""

Write-Host "💡 Press Ctrl+C in any window to stop that server" -ForegroundColor Yellow
Write-Host ""

# Start Laravel server
Start-Process powershell -ArgumentList "-NoExit", "-Command", "php artisan serve --port=8000" -WindowStyle Normal

# Wait a bit
Start-Sleep -Seconds 2

# Start Vite dev server
Start-Process powershell -ArgumentList "-NoExit", "-Command", "npm run dev" -WindowStyle Normal

# Wait a bit
Start-Sleep -Seconds 2

# Start Soketi server
Start-Process powershell -ArgumentList "-NoExit", "-Command", "soketi start" -WindowStyle Normal

Write-Host "✅ All servers started in separate windows!" -ForegroundColor Green
Write-Host ""
Write-Host "🎉 Development environment is ready!" -ForegroundColor Green 