# Запуск всех серверов для мобильного доступа
Write-Host "🚀 Запуск всех серверов для локальной сети..." -ForegroundColor Green
Write-Host ""

# Получаем IP адрес
$localIP = (Get-NetIPAddress -AddressFamily IPv4 -InterfaceAlias "Wi-Fi" | Where-Object {$_.IPAddress -notlike "169.254.*"}).IPAddress
if (-not $localIP) {
    $localIP = (Get-NetIPAddress -AddressFamily IPv4 -InterfaceAlias "Ethernet" | Where-Object {$_.IPAddress -notlike "169.254.*"}).IPAddress
}

Write-Host "🌐 Ваш IP адрес: $localIP" -ForegroundColor Cyan
Write-Host ""
Write-Host "📱 URL для мобильного доступа:" -ForegroundColor White
Write-Host "   🌐 Laravel: http://$localIP:8000" -ForegroundColor Green
Write-Host "   ⚡ Vite: http://$localIP:5173" -ForegroundColor Green
Write-Host "   🔌 Soketi: http://$localIP:6001" -ForegroundColor Green
Write-Host ""
Write-Host "💡 Убедитесь что:" -ForegroundColor Yellow
Write-Host "   • Телефон в той же WiFi сети" -ForegroundColor White
Write-Host "   • Файрвол не блокирует порты" -ForegroundColor White
Write-Host ""

Write-Host "🔄 Запуск серверов в отдельных окнах..." -ForegroundColor Yellow
Write-Host ""

# Запускаем Laravel сервер
Start-Process powershell -ArgumentList "-NoExit", "-Command", "php artisan serve --host=0.0.0.0 --port=8000" -WindowStyle Normal
Start-Sleep -Seconds 2

# Запускаем Vite сервер
Start-Process powershell -ArgumentList "-NoExit", "-Command", "npm run dev -- --host 0.0.0.0" -WindowStyle Normal
Start-Sleep -Seconds 2

# Запускаем Soketi сервер
Start-Process powershell -ArgumentList "-NoExit", "-Command", "soketi start" -WindowStyle Normal

Write-Host "✅ Все серверы запущены!" -ForegroundColor Green
Write-Host "📱 Теперь можете зайти с телефона по адресу: http://$localIP:8000" -ForegroundColor Cyan 