<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
    <!-- Главная страница -->
    <url>
        <loc>https://bonusradar.ru/</loc>
        <lastmod>{{ now()->format('Y-m-d') }}</lastmod>
        <changefreq>daily</changefreq>
        <priority>1.0</priority>
    </url>
    
    <!-- Основные страницы -->
    <url>
        <loc>https://bonusradar.ru/bookmakers</loc>
        <lastmod>{{ now()->format('Y-m-d') }}</lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.9</priority>
    </url>
    
    <url>
        <loc>https://bonusradar.ru/promo-codes</loc>
        <lastmod>{{ now()->format('Y-m-d') }}</lastmod>
        <changefreq>daily</changefreq>
        <priority>0.9</priority>
    </url>
    
    <url>
        <loc>https://bonusradar.ru/predictions</loc>
        <lastmod>{{ now()->format('Y-m-d') }}</lastmod>
        <changefreq>daily</changefreq>
        <priority>0.8</priority>
    </url>
    
    <url>
        <loc>https://bonusradar.ru/predictors</loc>
        <lastmod>{{ now()->format('Y-m-d') }}</lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.8</priority>
    </url>
    
    <url>
        <loc>https://bonusradar.ru/news</loc>
        <lastmod>{{ now()->format('Y-m-d') }}</lastmod>
        <changefreq>daily</changefreq>
        <priority>0.9</priority>
    </url>
    

    
    <!-- Информационные страницы -->
    <url>
        <loc>https://bonusradar.ru/faq</loc>
        <lastmod>{{ now()->format('Y-m-d') }}</lastmod>
        <changefreq>monthly</changefreq>
        <priority>0.6</priority>
    </url>
    
    <url>
        <loc>https://bonusradar.ru/contacts</loc>
        <lastmod>{{ now()->format('Y-m-d') }}</lastmod>
        <changefreq>monthly</changefreq>
        <priority>0.6</priority>
    </url>
    
    <url>
        <loc>https://bonusradar.ru/help</loc>
        <lastmod>{{ now()->format('Y-m-d') }}</lastmod>
        <changefreq>monthly</changefreq>
        <priority>0.6</priority>
    </url>
    
    <!-- Правовые страницы -->
    <url>
        <loc>https://bonusradar.ru/terms-of-service</loc>
        <lastmod>{{ now()->format('Y-m-d') }}</lastmod>
        <changefreq>yearly</changefreq>
        <priority>0.4</priority>
    </url>
    
    <url>
        <loc>https://bonusradar.ru/privacy-policy</loc>
        <lastmod>{{ now()->format('Y-m-d') }}</lastmod>
        <changefreq>yearly</changefreq>
        <priority>0.4</priority>
    </url>
    
    <!-- Страницы букмекеров -->
    @foreach($bookmakers as $bookmaker)
    <url>
        <loc>https://bonusradar.ru/bookmakers/{{ $bookmaker->slug }}</loc>
        <lastmod>{{ $bookmaker->updated_at->format('Y-m-d') }}</lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.8</priority>
    </url>
    
    <url>
        <loc>https://bonusradar.ru/bookmakers/{{ $bookmaker->slug }}/promo-codes</loc>
        <lastmod>{{ $bookmaker->updated_at->format('Y-m-d') }}</lastmod>
        <changefreq>daily</changefreq>
        <priority>0.8</priority>
    </url>
    @endforeach
    

    
    <!-- Страницы прогнозов -->
    @foreach($predictions as $prediction)
    <url>
        <loc>https://bonusradar.ru/predictions/{{ $prediction->id }}</loc>
        <lastmod>{{ $prediction->updated_at->format('Y-m-d') }}</lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.7</priority>
    </url>
    @endforeach
    
    <!-- Страницы прогнозистов -->
    @foreach($predictors as $predictor)
    <url>
        <loc>https://bonusradar.ru/predictors/{{ $predictor->id }}</loc>
        <lastmod>{{ $predictor->updated_at->format('Y-m-d') }}</lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.6</priority>
    </url>
    @endforeach
    
    <!-- Страницы новостей -->
    @foreach($news as $article)
    <url>
        <loc>https://bonusradar.ru/news/{{ $article->slug }}</loc>
        <lastmod>{{ $article->updated_at->format('Y-m-d') }}</lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.7</priority>
    </url>
    @endforeach
</urlset> 