<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Восстановление пароля</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .logo {
            max-width: 200px;
            height: auto;
        }
        .content {
            background: #f9f9f9;
            padding: 30px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        .button {
            display: inline-block;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 30px;
            text-decoration: none;
            border-radius: 8px;
            font-weight: bold;
            margin: 20px 0;
        }
        .footer {
            text-align: center;
            color: #666;
            font-size: 14px;
        }
        .warning {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="{{ asset('logo/fabula-ai.png') }}" alt="BONUSRADAR" class="logo">
        <h1>Восстановление пароля</h1>
    </div>

    <div class="content">
        <p>Здравствуйте, <strong>{{ $user->name }}</strong>!</p>
        
        <p>Мы получили запрос на восстановление пароля для вашего аккаунта на BONUSRADAR.</p>
        
        <p>Для создания нового пароля нажмите на кнопку ниже:</p>
        
        <div style="text-align: center;">
            <a href="{{ url('/reset-password?token=' . $token . '&email=' . $user->email) }}" class="button">
                Восстановить пароль
            </a>
        </div>
        
        <div class="warning">
            <strong>⚠️ Важно:</strong>
            <ul>
                <li>Эта ссылка действительна только 60 минут</li>
                <li>Если вы не запрашивали восстановление пароля, просто проигнорируйте это письмо</li>
                <li>Никогда не передавайте эту ссылку третьим лицам</li>
            </ul>
        </div>
        
        <p>Если кнопка не работает, скопируйте и вставьте эту ссылку в браузер:</p>
        <p style="word-break: break-all; color: #667eea;">
            {{ url('/reset-password?token=' . $token . '&email=' . $user->email) }}
        </p>
    </div>

    <div class="footer">
        <p>С уважением, команда BONUSRADAR</p>
        <p>Если у вас есть вопросы, свяжитесь с нами: support@bonusradar.com</p>
        <p>© {{ date('Y') }} BONUSRADAR. Все права защищены.</p>
    </div>
</body>
</html> 