import './bootstrap';
import { createApp } from 'vue';
import { createRouter, createWebHistory } from 'vue-router';
import App from './App.vue';

import Home from './components/Home.vue';
import Bookmakers from './components/Bookmakers.vue';
import BookmakerDetail from './components/BookmakerDetail.vue';
import BookmakerPromoCodes from './components/BookmakerPromoCodes.vue';
import PromoCodes from './components/PromoCodes.vue';
import Predictions from './components/Predictions.vue';
import Predictors from './components/Predictors.vue';
import Profile from './components/Profile.vue';
import UserProfile from './components/UserProfile.vue';
import FAQ from './components/FAQ.vue';
import Contacts from './components/Contacts.vue';
import PrivacyPolicy from './components/PrivacyPolicy.vue';
import TermsOfService from './components/TermsOfService.vue';
import Help from './components/Help.vue';
import Login from './components/Auth/Login.vue';
import Register from './components/Auth/Register.vue';
import ForgotPassword from './components/Auth/ForgotPassword.vue';
import ResetPassword from './components/Auth/ResetPassword.vue';
import AdminDashboard from './components/Admin/Dashboard.vue';
import AdminUsers from './components/Admin/Users.vue';
import AdminBookmakers from './components/Admin/Bookmakers.vue';
import AdminCasinos from './components/Admin/Casinos.vue';
import AdminPromoCodes from './components/Admin/PromoCodes.vue';
import AdminParser from './components/Admin/Parser.vue';
import PragmaticGame from './components/PragmaticGame.vue';
import Slots from './components/Slots/Slots.vue';
import Slot from './components/Slots/Slot.vue';
import Casinos from './components/Casino/Casinos.vue';
import Casino from './components/Casino/Casino.vue';
import MobileApp from './components/MobileApp.vue';
import FortuneWheelPage from './components/FortuneWheelPage.vue';
import News from './components/News.vue';
import NewsDetail from './components/NewsDetail.vue';
import NewsCategory from './components/NewsCategory.vue';

// Profile components
import ProfileAbout from './components/Profile/About.vue';
import ProfilePromo from './components/Profile/Promo.vue';
import ProfileStats from './components/Profile/StatsCards.vue';
import ProfilePredictions from './components/Profile/UserPredictions.vue';
import ProfileReferrals from './components/Profile/ReferralsList.vue';
import ProfilePoints from './components/Profile/PointsHistory.vue';
import ProfileFollows from './components/Profile/FollowsSection.vue';
import ProfileSettings from './components/Profile/SettingsSection.vue';
import ProfileMessages from './components/Profile/Messages.vue';

import MainLayout from './layouts/MainLayout.vue';
import AdminLayout from './layouts/AdminLayout.vue';
import ProfileLayout from './layouts/ProfileLayout.vue';

const router = createRouter({
    history: createWebHistory(),
    scrollBehavior(to, from, savedPosition) {
        if (to.hash) {
            return {
                el: to.hash
            };
        }
        if (savedPosition) {
            return savedPosition;
        }
        return { top: 0 };
    },
    routes: [
        {
            path: '/',
            component: MainLayout,
            children: [
                { path: '', component: Home },
                { path: 'bookmakers', component: Bookmakers },
                { path: 'bookmakers/:slug', component: BookmakerDetail },
                { path: 'bookmakers/:slug/promo-codes', component: BookmakerPromoCodes },
                { path: 'promo-codes', component: PromoCodes },
                { path: 'predictions', component: Predictions },
                { path: 'predictors', component: Predictors },
                { path: 'news', component: News },
                { path: 'news/category/:slug', component: NewsCategory },
                { path: 'news/:slug', component: NewsDetail },
                { path: 'slots', component: Slots },
                { path: 'slot/:slug', component: Slot },
                { path: 'casino', component: Casinos },
                { path: 'casino/:slug', component: Casino },
                { path: 'mobile-app', component: MobileApp },
                { path: 'fortune-wheel', component: FortuneWheelPage },
                { path: 'profile/:username', component: UserProfile },
                { path: 'profile', redirect: '/profile/about' },
                { 
                  path: 'profile/about', 
                  component: ProfileLayout, 
                  meta: { requiresAuth: true },
                  children: [{ path: '', component: ProfileAbout }]
                },
                { 
                  path: 'profile/promo', 
                  component: ProfileLayout, 
                  meta: { requiresAuth: true },
                  children: [{ path: '', component: ProfilePromo }]
                },
                { 
                  path: 'profile/stats', 
                  component: ProfileLayout, 
                  meta: { requiresAuth: true },
                  children: [{ path: '', component: ProfileStats }]
                },
                { 
                  path: 'profile/predictions', 
                  component: ProfileLayout, 
                  meta: { requiresAuth: true },
                  children: [{ path: '', component: ProfilePredictions }]
                },
                { 
                  path: 'profile/referrals', 
                  component: ProfileLayout, 
                  meta: { requiresAuth: true },
                  children: [{ path: '', component: ProfileReferrals }]
                },
                { 
                  path: 'profile/points', 
                  component: ProfileLayout, 
                  meta: { requiresAuth: true },
                  children: [{ path: '', component: ProfilePoints }]
                },
                { 
                  path: 'profile/follows', 
                  component: ProfileLayout, 
                  meta: { requiresAuth: true },
                  children: [{ path: '', component: ProfileFollows }]
                },
                { 
                  path: 'profile/messages', 
                  component: ProfileLayout, 
                  meta: { requiresAuth: true },
                  children: [{ path: '', component: ProfileMessages }]
                },
                { 
                  path: 'profile/settings', 
                  component: ProfileLayout, 
                  meta: { requiresAuth: true },
                  children: [{ path: '', component: ProfileSettings }]
                },
                { path: 'faq', component: FAQ },
                { path: 'contacts', component: Contacts },
                { path: 'privacy-policy', component: PrivacyPolicy },
                { path: 'terms-of-service', component: TermsOfService },
                { path: 'help', component: Help },
                { path: 'pragmatic-game', component: PragmaticGame },
                { path: 'login', component: Login },
                { path: 'register', component: Register },
                { path: 'forgot-password', component: ForgotPassword },
                { path: 'reset-password', component: ResetPassword },
            ]
        },
        {
            path: '/admin',
            component: AdminLayout,
            meta: { requiresAuth: true, requiresAdmin: true },
            children: [
                { path: '', component: AdminDashboard },
                { path: 'users', component: AdminUsers },
                { path: 'bookmakers', component: AdminBookmakers },
                { path: 'casinos', component: AdminCasinos },
                { path: 'promo-codes', component: AdminPromoCodes },
                { path: 'parser', component: AdminParser },
            ]
        }
    ]
});

router.beforeEach((to, from, next) => {
    const token = localStorage.getItem('token');
    const user = window.safeJsonParse(localStorage.getItem('user'), {});
    
    if (to.meta.requiresAuth && !token) {
        next('/login');
    } else if (to.meta.requiresAdmin && user.role !== 'admin') {
        next('/');
    } else {
        next();
    }
});

// Глобальные функции
window.safeJsonParse = (str, defaultValue = null) => {
    try {
        return str ? JSON.parse(str) : defaultValue;
    } catch (e) {
        console.error('JSON parse error:', e);
        return defaultValue;
    }
};

window.logout = () => {
    localStorage.removeItem('token');
    localStorage.removeItem('user');
    window.dispatchEvent(new CustomEvent('auth:logout'));
    window.location.href = '/';
};

const app = createApp(App);
app.use(router);
app.mount('#app');
