@echo off
echo ========================================
echo    УСТАНОВКА ПРОЕКТА
echo ========================================
echo.

echo [1/6] Проверка зависимостей...
php --version >nul 2>&1
if errorlevel 1 (
    echo ❌ PHP не найден! Установите PHP 8.2+
    pause
    exit /b 1
)
echo ✅ PHP найден

composer --version >nul 2>&1
if errorlevel 1 (
    echo ❌ Composer не найден! Установите Composer
    pause
    exit /b 1
)
echo ✅ Composer найден

node --version >nul 2>&1
if errorlevel 1 (
    echo ❌ Node.js не найден! Установите Node.js
    pause
    exit /b 1
)
echo ✅ Node.js найден

echo.
echo [2/6] Установка PHP зависимостей...
composer install --no-interaction
if errorlevel 1 (
    echo ❌ Ошибка установки PHP зависимостей
    pause
    exit /b 1
)
echo ✅ PHP зависимости установлены

echo.
echo [3/6] Установка Node.js зависимостей...
npm install
if errorlevel 1 (
    echo ❌ Ошибка установки Node.js зависимостей
    pause
    exit /b 1
)
echo ✅ Node.js зависимости установлены

echo.
echo [4/6] Настройка окружения...
if not exist .env (
    copy .env.example .env
    echo ✅ .env файл создан
) else (
    echo ✅ .env файл уже существует
)

php artisan key:generate --no-interaction
echo ✅ Ключ приложения сгенерирован

echo.
echo [5/6] Настройка базы данных...
if not exist database\database.sqlite (
    type nul > database\database.sqlite
    echo ✅ База данных SQLite создана
) else (
    echo ✅ База данных уже существует
)

php artisan migrate --no-interaction
if errorlevel 1 (
    echo ❌ Ошибка миграции базы данных
    pause
    exit /b 1
)
echo ✅ Миграции выполнены

php artisan db:seed --no-interaction
if errorlevel 1 (
    echo ❌ Ошибка заполнения тестовыми данными
    pause
    exit /b 1
)
echo ✅ Тестовые данные добавлены

echo.
echo [6/6] Очистка кэша...
php artisan config:clear --no-interaction
php artisan cache:clear --no-interaction
php artisan view:clear --no-interaction
echo ✅ Кэш очищен

echo.
echo ========================================
echo    УСТАНОВКА ЗАВЕРШЕНА! 🎉
echo ========================================
echo.
echo Тестовые аккаунты:
echo   Админ: admin@example.com / password
echo   Пользователь: user@example.com / password
echo.
echo Для запуска используйте:
echo   start-simple.bat
echo.
echo Или команду:
echo   php artisan serve:simple --vite
echo.
pause 