<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class TestUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Создаем тестового пользователя
        User::create([
            'name' => 'Тестовый Пользователь',
            'email' => 'test@example.com',
            'password' => Hash::make('password'),
            'email_verified_at' => now(),
            'username' => 'testuser',
            'phone' => '+7 (999) 123-45-67',
            'birth_date' => '1990-01-01',
            'country' => 'Россия',
            'city' => 'Москва',
            'referral_code' => 'TEST123',
            'total_points' => 1000,
            'available_points' => 1000,
            'total_profit' => 5000.00,
            'predictions_count' => 50,
            'correct_predictions' => 35,
            'success_rate' => 70.00,
            'is_verified' => true,
            'role' => 'user',
        ]);

        // Создаем админа
        User::create([
            'name' => 'Администратор',
            'email' => 'admin@example.com',
            'password' => Hash::make('password'),
            'email_verified_at' => now(),
            'username' => 'admin',
            'phone' => '+7 (999) 987-65-43',
            'birth_date' => '1985-01-01',
            'country' => 'Россия',
            'city' => 'Москва',
            'referral_code' => 'ADMIN456',
            'total_points' => 5000,
            'available_points' => 5000,
            'total_profit' => 25000.00,
            'predictions_count' => 200,
            'correct_predictions' => 180,
            'success_rate' => 90.00,
            'is_verified' => true,
            'role' => 'admin',
        ]);

        // Создаем партнера
        User::create([
            'name' => 'Партнер',
            'email' => 'partner@example.com',
            'password' => Hash::make('password'),
            'email_verified_at' => now(),
            'username' => 'partner',
            'phone' => '+7 (999) 555-55-55',
            'birth_date' => '1988-01-01',
            'country' => 'Россия',
            'city' => 'Санкт-Петербург',
            'referral_code' => 'PARTNER789',
            'total_points' => 2500,
            'available_points' => 2500,
            'total_profit' => 15000.00,
            'predictions_count' => 100,
            'correct_predictions' => 75,
            'success_rate' => 75.00,
            'is_verified' => true,
            'role' => 'moderator',
        ]);

        $this->command->info('Тестовые пользователи созданы:');
        $this->command->info('Пользователь: test@example.com / password');
        $this->command->info('Админ: admin@example.com / password');
        $this->command->info('Партнер: partner@example.com / password');
    }
} 