<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class RealisticUsersSeeder extends Seeder
{
    public function run(): void
    {
        $users = [
            [
                'name' => 'Алексей Иванов',
                'username' => 'alex_sport',
                'email' => 'alex.sport@mail.ru',
                'bio' => 'Люблю футбол и ставки на спорт. Слежу за премьер-лигой и чемпионатом России.',
                'gender' => 'male',
                'phone' => '+7 916 123-45-67',
                'birth_date' => '1992-05-15',
                'country' => 'Россия',
                'city' => 'Москва',
                'referral_code' => 'ALEX92'
            ],
            [
                'name' => 'Марина Кузнецова',
                'username' => 'marina_bet',
                'email' => 'marina.bet@gmail.com',
                'bio' => 'Эксперт по теннису и баскетболу. Анализирую статистику и делаю качественные прогнозы.',
                'gender' => 'female',
                'phone' => '+7 903 234-56-78',
                'birth_date' => '1988-12-03',
                'country' => 'Россия',
                'city' => 'Санкт-Петербург',
                'referral_code' => 'MARINA88'
            ],
            [
                'name' => 'Дмитрий Соколов',
                'username' => 'dmitry_winer',
                'email' => 'dmitry.win@yandex.ru',
                'bio' => 'Профессиональный игрок. Специализируюсь на хоккее и футболе. В игре с 2015 года.',
                'gender' => 'male',
                'phone' => '+7 925 345-67-89',
                'birth_date' => '1990-08-22',
                'country' => 'Россия',
                'city' => 'Екатеринбург',
                'referral_code' => 'DMITRY90'
            ],
            [
                'name' => 'Анна Васильева',
                'username' => 'anna_predict',
                'email' => 'anna.predict@rambler.ru',
                'bio' => 'Люблю анализировать матчи и делиться своими мыслями. Футбол - моя страсть!',
                'gender' => 'female',
                'phone' => '+7 917 456-78-90',
                'birth_date' => '1995-03-10',
                'country' => 'Россия',
                'city' => 'Новосибирск',
                'referral_code' => 'ANNA95'
            ],
            [
                'name' => 'Сергей Громов',
                'username' => 'sergey_goal',
                'email' => 'sergey.goal@bk.ru',
                'bio' => 'Бывший футболист, теперь аналитик. Знаю игру изнутри и делюсь опытом.',
                'gender' => 'male',
                'phone' => '+7 909 567-89-01',
                'birth_date' => '1985-11-28',
                'country' => 'Россия',
                'city' => 'Казань',
                'referral_code' => 'SERGEY85'
            ],
            [
                'name' => 'Елена Смирнова',
                'username' => 'elena_smart',
                'email' => 'elena.smart@inbox.ru',
                'bio' => 'Математик по образованию, аналитик по призванию. Использую статистику для прогнозов.',
                'gender' => 'female',
                'phone' => '+7 926 678-90-12',
                'birth_date' => '1993-07-14',
                'country' => 'Россия',
                'city' => 'Ростов-на-Дону',
                'referral_code' => 'ELENA93'
            ],
            [
                'name' => 'Владимир Петров',
                'username' => 'vladimir_pro',
                'email' => 'vladimir.pro@list.ru',
                'bio' => 'Профессиональный каппер с 10-летним стажем. Специализация: европейские лиги.',
                'gender' => 'male',
                'phone' => '+7 903 789-01-23',
                'birth_date' => '1987-04-05',
                'country' => 'Россия',
                'city' => 'Уфа',
                'referral_code' => 'VLAD87'
            ],
            [
                'name' => 'Нина Орлова',
                'username' => 'nina_ace',
                'email' => 'nina.ace@yahoo.com',
                'bio' => 'Теннисный эксперт. Слежу за всеми турнирами и знаю всех игроков.',
                'gender' => 'female',
                'phone' => '+7 916 890-12-34',
                'birth_date' => '1991-09-18',
                'country' => 'Россия',
                'city' => 'Самара',
                'referral_code' => 'NINA91'
            ],
            [
                'name' => 'Андрей Морозов',
                'username' => 'andrey_ice',
                'email' => 'andrey.ice@hotmail.com',
                'bio' => 'Хоккей - моя жизнь! Анализирую КХЛ и НХЛ. Делюсь экспертизой.',
                'gender' => 'male',
                'phone' => '+7 925 901-23-45',
                'birth_date' => '1989-02-25',
                'country' => 'Россия',
                'city' => 'Челябинск',
                'referral_code' => 'ANDREY89'
            ],
            [
                'name' => 'Татьяна Белова',
                'username' => 'tatyana_ball',
                'email' => 'tatyana.ball@outlook.com',
                'bio' => 'Баскетбольный фанат. НБА, Евролига, ВТБ - знаю все лиги.',
                'gender' => 'female',
                'phone' => '+7 917 012-34-56',
                'birth_date' => '1994-06-30',
                'country' => 'Россия',
                'city' => 'Воронеж',
                'referral_code' => 'TATYANA94'
            ],
            [
                'name' => 'Михаил Козлов',
                'username' => 'mikhail_win',
                'email' => 'mikhail.kozlov@icloud.com',
                'bio' => 'Спортивный аналитик. Работаю с данными и статистикой для точных прогнозов.',
                'gender' => 'male',
                'phone' => '+7 903 123-45-67',
                'birth_date' => '1986-12-08',
                'country' => 'Россия',
                'city' => 'Пермь',
                'referral_code' => 'MIKHAIL86'
            ],
            [
                'name' => 'Светлана Федорова',
                'username' => 'svetlana_bet',
                'email' => 'svetlana.fedorova@protonmail.com',
                'bio' => 'Люблю спорт и математику. Комбинирую аналитику с интуицией.',
                'gender' => 'female',
                'phone' => '+7 926 234-56-78',
                'birth_date' => '1996-01-20',
                'country' => 'Россия',
                'city' => 'Краснодар',
                'referral_code' => 'SVETLANA96'
            ],
            [
                'name' => 'Константин Павлов',
                'username' => 'konstantin_pro',
                'email' => 'konstantin.pavlov@tutanota.com',
                'bio' => 'Профессиональный игрок на ставках. Специализация: live-ставки.',
                'gender' => 'male',
                'phone' => '+7 925 345-67-89',
                'birth_date' => '1984-10-12',
                'country' => 'Россия',
                'city' => 'Саратов',
                'referral_code' => 'KONSTANTIN84'
            ],
            [
                'name' => 'Ирина Попова',
                'username' => 'irina_sport',
                'email' => 'irina.popova@zoho.com',
                'bio' => 'Спортивный журналист. Пишу аналитику и делаю прогнозы на основе инсайдов.',
                'gender' => 'female',
                'phone' => '+7 917 456-78-90',
                'birth_date' => '1990-03-15',
                'country' => 'Россия',
                'city' => 'Тюмень',
                'referral_code' => 'IRINA90'
            ],
            [
                'name' => 'Павел Волков',
                'username' => 'pavel_ace',
                'email' => 'pavel.volkov@fastmail.com',
                'bio' => 'Бывший теннисист. Знаю игру изнутри и делюсь экспертизой.',
                'gender' => 'male',
                'phone' => '+7 909 567-89-01',
                'birth_date' => '1988-07-22',
                'country' => 'Россия',
                'city' => 'Иркутск',
                'referral_code' => 'PAVEL88'
            ],
            [
                'name' => 'Ольга Соловьева',
                'username' => 'olga_goal',
                'email' => 'olga.solovieva@mail.com',
                'bio' => 'Футбольный фанат с детства. Слежу за всеми топ-лигами Европы.',
                'gender' => 'female',
                'phone' => '+7 916 678-90-12',
                'birth_date' => '1992-11-05',
                'country' => 'Россия',
                'city' => 'Барнаул',
                'referral_code' => 'OLGA92'
            ],
            [
                'name' => 'Роман Егоров',
                'username' => 'roman_ice',
                'email' => 'roman.egorov@yandex.ru',
                'bio' => 'Хоккейный эксперт. Анализирую матчи и делюсь прогнозами.',
                'gender' => 'male',
                'phone' => '+7 903 789-01-23',
                'birth_date' => '1987-05-18',
                'country' => 'Россия',
                'city' => 'Ульяновск',
                'referral_code' => 'ROMAN87'
            ],
            [
                'name' => 'Юлия Андреева',
                'username' => 'yulia_smart',
                'email' => 'yulia.andreeva@gmail.com',
                'bio' => 'Экономист по образованию. Применяю аналитические методы к спорту.',
                'gender' => 'female',
                'phone' => '+7 925 890-12-34',
                'birth_date' => '1993-08-30',
                'country' => 'Россия',
                'city' => 'Томск',
                'referral_code' => 'YULIA93'
            ],
            [
                'name' => 'Денис Захаров',
                'username' => 'denis_win',
                'email' => 'denis.zakharov@rambler.ru',
                'bio' => 'Профессиональный каппер. Специализация: азиатские лиги.',
                'gender' => 'male',
                'phone' => '+7 917 901-23-45',
                'birth_date' => '1989-12-14',
                'country' => 'Россия',
                'city' => 'Кемерово',
                'referral_code' => 'DENIS89'
            ],
            [
                'name' => 'Наталия Мельникова',
                'username' => 'natalia_bet',
                'email' => 'natalia.melnikova@bk.ru',
                'bio' => 'Люблю спорт и статистику. Делюсь своими наблюдениями.',
                'gender' => 'female',
                'phone' => '+7 926 012-34-56',
                'birth_date' => '1995-04-25',
                'country' => 'Россия',
                'city' => 'Астрахань',
                'referral_code' => 'NATALIA95'
            ],
            [
                'name' => 'Артем Сергеев',
                'username' => 'artem_pro',
                'email' => 'artem.sergeev@inbox.ru',
                'bio' => 'Спортивный аналитик. Работаю с большими данными для прогнозов.',
                'gender' => 'male',
                'phone' => '+7 903 123-45-67',
                'birth_date' => '1986-09-08',
                'country' => 'Россия',
                'city' => 'Пенза',
                'referral_code' => 'ARTEM86'
            ],
            [
                'name' => 'Екатерина Смирнова',
                'username' => 'ekaterina_sport',
                'email' => 'ekaterina.smirnova@list.ru',
                'bio' => 'Журналист спортивного издания. Пишу аналитику и делаю прогнозы.',
                'gender' => 'female',
                'phone' => '+7 916 234-56-78',
                'birth_date' => '1991-06-12',
                'country' => 'Россия',
                'city' => 'Липецк',
                'referral_code' => 'EKATERINA91'
            ],
            [
                'name' => 'Александр Громов',
                'username' => 'alexander_ace',
                'email' => 'alexander.gromov@yahoo.com',
                'bio' => 'Теннисный тренер. Знаю технику и тактику игры.',
                'gender' => 'male',
                'phone' => '+7 925 345-67-89',
                'birth_date' => '1985-03-20',
                'country' => 'Россия',
                'city' => 'Киров',
                'referral_code' => 'ALEXANDER85'
            ],
            [
                'name' => 'Мария Соловьева',
                'username' => 'maria_goal',
                'email' => 'maria.solovieva@hotmail.com',
                'bio' => 'Футбольный фанат. Слежу за всеми матчами и анализирую статистику.',
                'gender' => 'female',
                'phone' => '+7 917 456-78-90',
                'birth_date' => '1994-01-28',
                'country' => 'Россия',
                'city' => 'Курск',
                'referral_code' => 'MARIA94'
            ],
            [
                'name' => 'Виталий Морозов',
                'username' => 'vitaly_ice',
                'email' => 'vitaly.morozov@outlook.com',
                'bio' => 'Хоккейный эксперт. Анализирую КХЛ и международные турниры.',
                'gender' => 'male',
                'phone' => '+7 909 567-89-01',
                'birth_date' => '1988-11-03',
                'country' => 'Россия',
                'city' => 'Тула',
                'referral_code' => 'VITALY88'
            ],
            [
                'name' => 'Анна Андреева',
                'username' => 'anna_smart',
                'email' => 'anna.andreeva@icloud.com',
                'bio' => 'Математик и спортивный аналитик. Использую науку для прогнозов.',
                'gender' => 'female',
                'phone' => '+7 926 678-90-12',
                'birth_date' => '1990-07-16',
                'country' => 'Россия',
                'city' => 'Рязань',
                'referral_code' => 'ANNA90'
            ],
            [
                'name' => 'Дмитрий Морозов',
                'username' => 'dmitry_win',
                'email' => 'dmitry.morozov@protonmail.com',
                'bio' => 'Профессиональный игрок. Специализация: live-ставки и экспрессы.',
                'gender' => 'male',
                'phone' => '+7 903 789-01-23',
                'birth_date' => '1987-02-09',
                'country' => 'Россия',
                'city' => 'Белгород',
                'referral_code' => 'DMITRY87'
            ],
            [
                'name' => 'Елена Волков',
                'username' => 'elena_volkov',
                'email' => 'elena.volkov@tutanota.com',
                'bio' => 'Люблю спорт и аналитику. Делюсь своими наблюдениями и прогнозами.',
                'gender' => 'female',
                'phone' => '+7 925 890-12-34',
                'birth_date' => '1993-10-22',
                'country' => 'Россия',
                'city' => 'Вологда',
                'referral_code' => 'ELENA93B'
            ],
            [
                'name' => 'Сергей Павлов',
                'username' => 'sergey_pavlov',
                'email' => 'sergey.pavlov@zoho.com',
                'bio' => 'Спортивный аналитик с 15-летним стажем. Эксперт по европейскому футболу.',
                'gender' => 'male',
                'phone' => '+7 903 789-01-23',
                'birth_date' => '1985-11-28',
                'country' => 'Россия',
                'city' => 'Казань',
                'referral_code' => 'SERGEY85B'
            ],
            [
                'name' => 'Нина Смирнова',
                'username' => 'nina_smirnova',
                'email' => 'nina.smirnova@fastmail.com',
                'bio' => 'Спортивный журналист. Пишу аналитику и делаю экспертные прогнозы.',
                'gender' => 'female',
                'phone' => '+7 916 890-12-34',
                'birth_date' => '1991-09-18',
                'country' => 'Россия',
                'city' => 'Самара',
                'referral_code' => 'NINA91B'
            ],
            [
                'name' => 'Андрей Громов',
                'username' => 'andrey_gromov',
                'email' => 'andrey.gromov@mail.com',
                'bio' => 'Теннисный эксперт. Слежу за всеми турнирами и знаю всех игроков.',
                'gender' => 'male',
                'phone' => '+7 925 901-23-45',
                'birth_date' => '1989-02-25',
                'country' => 'Россия',
                'city' => 'Челябинск',
                'referral_code' => 'ANDREY89B'
            ],
            [
                'name' => 'Татьяна Соловьева',
                'username' => 'tatyana_solovieva',
                'email' => 'tatyana.solovieva@yandex.ru',
                'bio' => 'Футбольный фанат с детства. Анализирую матчи и делюсь прогнозами.',
                'gender' => 'female',
                'phone' => '+7 917 012-34-56',
                'birth_date' => '1994-06-30',
                'country' => 'Россия',
                'city' => 'Воронеж',
                'referral_code' => 'TATYANA94B'
            ],
            [
                'name' => 'Михаил Морозов',
                'username' => 'mikhail_morozov',
                'email' => 'mikhail.morozov@gmail.com',
                'bio' => 'Хоккейный эксперт. Специализация: КХЛ и международные турниры.',
                'gender' => 'male',
                'phone' => '+7 903 123-45-67',
                'birth_date' => '1986-12-08',
                'country' => 'Россия',
                'city' => 'Пермь',
                'referral_code' => 'MIKHAIL86B'
            ],
            [
                'name' => 'Светлана Громова',
                'username' => 'svetlana_gromova',
                'email' => 'svetlana.gromova@rambler.ru',
                'bio' => 'Экономист и спортивный аналитик. Применяю научные методы к прогнозам.',
                'gender' => 'female',
                'phone' => '+7 926 234-56-78',
                'birth_date' => '1996-01-20',
                'country' => 'Россия',
                'city' => 'Краснодар',
                'referral_code' => 'SVETLANA96B'
            ],
            [
                'name' => 'Константин Волков',
                'username' => 'konstantin_volkov',
                'email' => 'konstantin.volkov@bk.ru',
                'bio' => 'Профессиональный каппер. Специализация: live-ставки и экспрессы.',
                'gender' => 'male',
                'phone' => '+7 925 345-67-89',
                'birth_date' => '1984-10-12',
                'country' => 'Россия',
                'city' => 'Саратов',
                'referral_code' => 'KONSTANTIN84B'
            ],
            [
                'name' => 'Ирина Волков',
                'username' => 'irina_volkov',
                'email' => 'irina.volkov@inbox.ru',
                'bio' => 'Люблю спорт и статистику. Делюсь своими наблюдениями и прогнозами.',
                'gender' => 'female',
                'phone' => '+7 917 456-78-90',
                'birth_date' => '1990-03-15',
                'country' => 'Россия',
                'city' => 'Тюмень',
                'referral_code' => 'IRINA90B'
            ],
            [
                'name' => 'Павел Павлов',
                'username' => 'pavel_pavlov',
                'email' => 'pavel.pavlov@list.ru',
                'bio' => 'Спортивный аналитик. Работаю с данными и статистикой для точных прогнозов.',
                'gender' => 'male',
                'phone' => '+7 909 567-89-01',
                'birth_date' => '1988-07-22',
                'country' => 'Россия',
                'city' => 'Иркутск',
                'referral_code' => 'PAVEL88B'
            ],
            [
                'name' => 'Ольга Смирнова',
                'username' => 'olga_smirnova',
                'email' => 'olga.smirnova@yahoo.com',
                'bio' => 'Спортивный журналист. Пишу аналитику и делаю экспертные прогнозы.',
                'gender' => 'female',
                'phone' => '+7 916 890-12-34',
                'birth_date' => '1991-09-18',
                'country' => 'Россия',
                'city' => 'Самара',
                'referral_code' => 'OLGA91'
            ],
            [
                'name' => 'Роман Громов',
                'username' => 'roman_gromov',
                'email' => 'roman.gromov@hotmail.com',
                'bio' => 'Теннисный эксперт. Слежу за всеми турнирами и знаю всех игроков.',
                'gender' => 'male',
                'phone' => '+7 925 901-23-45',
                'birth_date' => '1989-02-25',
                'country' => 'Россия',
                'city' => 'Челябинск',
                'referral_code' => 'ROMAN89'
            ],
            [
                'name' => 'Юлия Соловьева',
                'username' => 'yulia_solovieva',
                'email' => 'yulia.solovieva@outlook.com',
                'bio' => 'Футбольный фанат. Анализирую матчи и делюсь прогнозами.',
                'gender' => 'female',
                'phone' => '+7 917 012-34-56',
                'birth_date' => '1994-06-30',
                'country' => 'Россия',
                'city' => 'Воронеж',
                'referral_code' => 'YULIA94'
            ],
            [
                'name' => 'Денис Морозов',
                'username' => 'denis_morozov',
                'email' => 'denis.morozov@icloud.com',
                'bio' => 'Хоккейный эксперт. Специализация: КХЛ и международные турниры.',
                'gender' => 'male',
                'phone' => '+7 903 123-45-67',
                'birth_date' => '1986-12-08',
                'country' => 'Россия',
                'city' => 'Пермь',
                'referral_code' => 'DENIS86'
            ],
            [
                'name' => 'Наталия Громова',
                'username' => 'natalia_gromova',
                'email' => 'natalia.gromova@protonmail.com',
                'bio' => 'Математик и спортивный аналитик. Использую науку для прогнозов.',
                'gender' => 'female',
                'phone' => '+7 926 234-56-78',
                'birth_date' => '1996-01-20',
                'country' => 'Россия',
                'city' => 'Краснодар',
                'referral_code' => 'NATALIA96'
            ],
            [
                'name' => 'Артем Волков',
                'username' => 'artem_volkov',
                'email' => 'artem.volkov@tutanota.com',
                'bio' => 'Профессиональный каппер. Специализация: live-ставки.',
                'gender' => 'male',
                'phone' => '+7 925 345-67-89',
                'birth_date' => '1984-10-12',
                'country' => 'Россия',
                'city' => 'Саратов',
                'referral_code' => 'ARTEM84'
            ],
            [
                'name' => 'Екатерина Павлова',
                'username' => 'ekaterina_pavlova',
                'email' => 'ekaterina.pavlova@zoho.com',
                'bio' => 'Люблю спорт и аналитику. Делюсь своими наблюдениями.',
                'gender' => 'female',
                'phone' => '+7 917 456-78-90',
                'birth_date' => '1990-03-15',
                'country' => 'Россия',
                'city' => 'Тюмень',
                'referral_code' => 'EKATERINA90'
            ],
            [
                'name' => 'Александр Павлов',
                'username' => 'alexander_pavlov',
                'email' => 'alexander.pavlov@fastmail.com',
                'bio' => 'Спортивный аналитик с 12-летним стажем. Эксперт по европейскому футболу.',
                'gender' => 'male',
                'phone' => '+7 909 567-89-01',
                'birth_date' => '1988-07-22',
                'country' => 'Россия',
                'city' => 'Иркутск',
                'referral_code' => 'ALEXANDER88'
            ],
            [
                'name' => 'Мария Смирнова',
                'username' => 'maria_smirnova',
                'email' => 'maria.smirnova@mail.com',
                'bio' => 'Спортивный журналист. Пишу аналитику и делаю экспертные прогнозы.',
                'gender' => 'female',
                'phone' => '+7 916 890-12-34',
                'birth_date' => '1991-09-18',
                'country' => 'Россия',
                'city' => 'Самара',
                'referral_code' => 'MARIA91'
            ],
            [
                'name' => 'Виталий Громов',
                'username' => 'vitaly_gromov',
                'email' => 'vitaly.gromov@yandex.ru',
                'bio' => 'Теннисный эксперт. Слежу за всеми турнирами и знаю всех игроков.',
                'gender' => 'male',
                'phone' => '+7 925 901-23-45',
                'birth_date' => '1989-02-25',
                'country' => 'Россия',
                'city' => 'Челябинск',
                'referral_code' => 'VITALY89'
            ],
            [
                'name' => 'Анна Соловьева',
                'username' => 'anna_solovieva',
                'email' => 'anna.solovieva@gmail.com',
                'bio' => 'Футбольный фанат с детства. Анализирую матчи и делюсь прогнозами.',
                'gender' => 'female',
                'phone' => '+7 917 012-34-56',
                'birth_date' => '1994-06-30',
                'country' => 'Россия',
                'city' => 'Воронеж',
                'referral_code' => 'ANNA94'
            ],
            [
                'name' => 'Дмитрий Морозов',
                'username' => 'dmitry_morozov',
                'email' => 'dmitry.morozov@rambler.ru',
                'bio' => 'Хоккейный эксперт. Специализация: КХЛ и международные турниры.',
                'gender' => 'male',
                'phone' => '+7 903 123-45-67',
                'birth_date' => '1986-12-08',
                'country' => 'Россия',
                'city' => 'Пермь',
                'referral_code' => 'DMITRY86'
            ],
            [
                'name' => 'Елена Волков',
                'username' => 'elena_volkov2',
                'email' => 'elena.volkov@bk.ru',
                'bio' => 'Экономист и спортивный аналитик. Применяю научные методы к прогнозам.',
                'gender' => 'female',
                'phone' => '+7 926 234-56-78',
                'birth_date' => '1996-01-20',
                'country' => 'Россия',
                'city' => 'Краснодар',
                'referral_code' => 'ELENA96'
            ],
            [
                'name' => 'Сергей Волков',
                'username' => 'sergey_volkov',
                'email' => 'sergey.volkov@inbox.ru',
                'bio' => 'Профессиональный каппер. Специализация: live-ставки и экспрессы.',
                'gender' => 'male',
                'phone' => '+7 925 345-67-89',
                'birth_date' => '1984-10-12',
                'country' => 'Россия',
                'city' => 'Саратов',
                'referral_code' => 'SERGEY84'
            ],
            [
                'name' => 'Нина Павлова',
                'username' => 'nina_pavlova',
                'email' => 'nina.pavlova@list.ru',
                'bio' => 'Люблю спорт и статистику. Делюсь своими наблюдениями и прогнозами.',
                'gender' => 'female',
                'phone' => '+7 917 456-78-90',
                'birth_date' => '1990-03-15',
                'country' => 'Россия',
                'city' => 'Тюмень',
                'referral_code' => 'NINA90'
            ]
        ];

        foreach ($users as $userData) {
            User::create([
                'name' => $userData['name'],
                'username' => $userData['username'],
                'email' => $userData['email'],
                'password' => Hash::make('password123'),
                'bio' => $userData['bio'],
                'gender' => $userData['gender'],
                'phone' => $userData['phone'],
                'birth_date' => $userData['birth_date'],
                'country' => $userData['country'],
                'city' => $userData['city'],
                'referral_code' => $userData['referral_code'],
                'email_verified_at' => now(),
                'remember_token' => Str::random(10),
            ]);
        }
    }
} 