<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Rank;

class RankSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $ranks = [
            [
                'name' => 'Новичок',
                'slug' => 'novice',
                'min_points' => 0,
                'max_points' => 99,
                'color' => '#6B7280',
                'icon' => '🌟',
                'description' => 'Только начинаете свой путь в мире букмекинга',
                'level' => 1
            ],
            [
                'name' => 'Любитель',
                'slug' => 'amateur',
                'min_points' => 100,
                'max_points' => 199,
                'color' => '#10B981',
                'icon' => '🎯',
                'description' => 'Делаете первые успешные прогнозы',
                'level' => 2
            ],
            [
                'name' => 'Игрок',
                'slug' => 'player',
                'min_points' => 200,
                'max_points' => 299,
                'color' => '#3B82F6',
                'icon' => '🎮',
                'description' => 'Регулярно делаете ставки и получаете прибыль',
                'level' => 3
            ],
            [
                'name' => 'Профессионал',
                'slug' => 'professional',
                'min_points' => 300,
                'max_points' => 399,
                'color' => '#8B5CF6',
                'icon' => '💼',
                'description' => 'Опытный игрок с высоким процентом успешных ставок',
                'level' => 4
            ],
            [
                'name' => 'Эксперт',
                'slug' => 'expert',
                'min_points' => 400,
                'max_points' => 499,
                'color' => '#F59E0B',
                'icon' => '🎓',
                'description' => 'Признанный эксперт в области спортивных ставок',
                'level' => 5
            ],
            [
                'name' => 'Мастер',
                'slug' => 'master',
                'min_points' => 500,
                'max_points' => 599,
                'color' => '#EF4444',
                'icon' => '👑',
                'description' => 'Мастер спортивных прогнозов с отличной репутацией',
                'level' => 6
            ],
            [
                'name' => 'Гуру',
                'slug' => 'guru',
                'min_points' => 600,
                'max_points' => 699,
                'color' => '#EC4899',
                'icon' => '🧙‍♂️',
                'description' => 'Гуру букмекинга с феноменальными результатами',
                'level' => 7
            ],
            [
                'name' => 'Легенда',
                'slug' => 'legend',
                'min_points' => 700,
                'max_points' => 799,
                'color' => '#DC2626',
                'icon' => '🏆',
                'description' => 'Легендарный игрок, известный во всем сообществе',
                'level' => 8
            ],
            [
                'name' => 'Чемпион',
                'slug' => 'champion',
                'min_points' => 800,
                'max_points' => 899,
                'color' => '#7C3AED',
                'icon' => '🥇',
                'description' => 'Чемпион среди букмекеров с выдающимися достижениями',
                'level' => 9
            ],
            [
                'name' => 'Император',
                'slug' => 'emperor',
                'min_points' => 900,
                'max_points' => 1000,
                'color' => '#000000',
                'icon' => '👑',
                'description' => 'Император букмекинга - высший ранг, доступный только избранным',
                'level' => 10
            ]
        ];

        foreach ($ranks as $rank) {
            Rank::updateOrCreate(
                ['slug' => $rank['slug']],
                $rank
            );
        }
    }
}
