<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Category;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            [
                'name' => 'Популярные',
                'slug' => 'popular',
                'description' => 'Самые популярные букмекеры',
                'icon' => 'star',
                'color' => '#FF6B6B',
                'sort_order' => 1,
            ],
            [
                'name' => 'Лицензированные',
                'slug' => 'licensed',
                'description' => 'Букмекеры с официальными лицензиями',
                'icon' => 'shield-check',
                'color' => '#4ECDC4',
                'sort_order' => 2,
            ],
            [
                'name' => 'С высокими коэффициентами',
                'slug' => 'high-odds',
                'description' => 'Букмекеры с высокими коэффициентами',
                'icon' => 'trending-up',
                'color' => '#45B7D1',
                'sort_order' => 3,
            ],
            [
                'name' => 'С быстрыми выплатами',
                'slug' => 'fast-payouts',
                'description' => 'Букмекеры с быстрыми выплатами',
                'icon' => 'clock',
                'color' => '#96CEB4',
                'sort_order' => 4,
            ],
            [
                'name' => 'Криптовалютные',
                'slug' => 'crypto',
                'description' => 'Букмекеры с поддержкой криптовалют',
                'icon' => 'currency-bitcoin',
                'color' => '#FFEAA7',
                'sort_order' => 5,
            ],
        ];

        foreach ($categories as $category) {
            Category::create($category);
        }
    }
}
