<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Casino;
use Illuminate\Support\Str;

class CasinoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $casinos = [
            [
                'name' => 'Fonbet Casino',
                'slug' => 'fonbet-casino',
                'description' => 'Официальная лицензия, более 20 провайдеров, live-игры. Популярные провайдеры: Endorphina, Betsoft, Pragmatic Play, Bgaming, NetEnt, Igrosoft, Belatra, Amatic.',
                'rating' => 4.5,
                'min_deposit' => 100,
                'license' => 'Официальная лицензия',
                'games_count' => 1000,
                'providers_count' => 20,
                'payment_methods' => ['Mastercard', 'Visa', 'Белкарт', 'ЕРИП', 'Оплати'],
                'currencies' => ['RUB', 'BYN'],
                'languages' => ['ru', 'en'],
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Fonbet Casino - Официальное казино с лицензией',
                'meta_description' => 'Fonbet Casino предлагает более 1000 игр от 20+ провайдеров. Официальная лицензия, live-игры, быстрые выплаты.',
            ],
            [
                'name' => 'Maxline',
                'slug' => 'maxline',
                'description' => 'Есть лицензия, более 2000 игр, есть клиент для смартфонов. Популярные провайдеры: Endorphina, Betsoft, Pragmatic Play, Bgaming, Belatra, Amatic, Fugaso, Booming Games.',
                'rating' => 4.7,
                'min_deposit' => 100,
                'license' => 'Есть лицензия',
                'games_count' => 2000,
                'providers_count' => 25,
                'payment_methods' => ['Mastercard', 'Visa', 'Lifecell', 'Белкарт', 'ЕРИП', 'МТС', 'Оплати'],
                'currencies' => ['RUB', 'BYN'],
                'languages' => ['ru', 'en'],
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Maxline - Казино с более 2000 игр',
                'meta_description' => 'Maxline предлагает более 2000 игр от ведущих провайдеров. Есть лицензия, мобильное приложение, быстрые выплаты.',
            ],
            [
                'name' => 'Betera',
                'slug' => 'betera',
                'description' => 'Лицензия, легальная работа на территории страны, более 1000 слотов, live-игры, ставки на спорт. Популярные провайдеры: Endorphina, Betsoft, Pragmatic Play, Bgaming, Novomatic, NetEnt, Belatra, Amatic.',
                'rating' => 4.8,
                'min_deposit' => 100,
                'license' => 'Лицензия, легальная работа',
                'games_count' => 1000,
                'providers_count' => 30,
                'payment_methods' => ['Mastercard', 'Мир', 'Visa', 'БЕЛ', 'Белкарт', 'ЕРИП', 'ЧЕР', 'CAS'],
                'currencies' => ['RUB', 'BYN'],
                'languages' => ['ru', 'en'],
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Betera - Легальное казино с лицензией',
                'meta_description' => 'Betera - легальное казино с лицензией. Более 1000 слотов, live-игры, ставки на спорт.',
            ],
            [
                'name' => 'Покердом',
                'slug' => 'pokerdom',
                'description' => 'Лицензия Кюрасао, около 2000 игр в каталоге, деморежим во всех аппаратах. Популярные провайдеры: Endorphina, Betsoft, Pragmatic Play, Bgaming, Novomatic, NetEnt, Igrosoft, Belatra.',
                'rating' => 5.0,
                'min_deposit' => 100,
                'license' => 'Лицензия Кюрасао',
                'games_count' => 2000,
                'providers_count' => 35,
                'payment_methods' => ['СБП', 'Mastercard', 'Ethereum', 'Мир', 'Bitcoin', 'Visa', 'Litecoin', 'LuxonPay'],
                'currencies' => ['RUB', 'USD', 'EUR', 'BTC', 'ETH'],
                'languages' => ['ru', 'en'],
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Покердом - Казино с лицензией Кюрасао',
                'meta_description' => 'Покердом предлагает около 2000 игр с деморежимом. Лицензия Кюрасао, криптоплатежи.',
            ],
            [
                'name' => 'Bounty Casino',
                'slug' => 'bounty-casino',
                'description' => 'Наличие лицензии Кюрасао, хорошая коллекция автоматов, кешбэк до 10%. Популярные провайдеры: Endorphina, Betsoft, Pragmatic Play, Bgaming, Novomatic, NetEnt, Igrosoft, Belatra.',
                'rating' => 5.0,
                'min_deposit' => 100,
                'license' => 'Лицензия Кюрасао',
                'games_count' => 1500,
                'providers_count' => 30,
                'payment_methods' => ['СБП', 'Mastercard', 'Ethereum', 'Мир', 'Bitcoin', 'Visa', 'ЮMoney', 'Tron'],
                'currencies' => ['RUB', 'USD', 'EUR', 'BTC', 'ETH'],
                'languages' => ['ru', 'en'],
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Bounty Casino - Казино с кешбэком до 10%',
                'meta_description' => 'Bounty Casino предлагает хорошую коллекцию автоматов и кешбэк до 10%. Лицензия Кюрасао.',
            ],
            [
                'name' => 'Aurora Casino',
                'slug' => 'aurora-casino',
                'description' => 'Работает по лицензии Кюрасао, бездепозитные бонусы в размере 1000 фриспинов, букмекерские ставки на сайте. Популярные провайдеры: Endorphina, Betsoft, Pragmatic Play, Bgaming, Novomatic, NetEnt, Igrosoft, Belatra.',
                'rating' => 5.0,
                'min_deposit' => 100,
                'license' => 'Лицензия Кюрасао',
                'games_count' => 1800,
                'providers_count' => 32,
                'payment_methods' => ['СБП', 'Mastercard', 'Ethereum', 'Мир', 'Bitcoin', 'Visa', 'Litecoin', '2P2'],
                'currencies' => ['RUB', 'USD', 'EUR', 'BTC', 'ETH'],
                'languages' => ['ru', 'en'],
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Aurora Casino - Казино с бездепозитными бонусами',
                'meta_description' => 'Aurora Casino предлагает бездепозитные бонусы 1000 фриспинов. Лицензия Кюрасао, букмекерские ставки.',
            ],
            [
                'name' => 'Lex Casino',
                'slug' => 'lex-casino',
                'description' => 'Лицензия регулятора Кюрасао, каталог из 7500 слотов с высоким RTP и другие игры, безлимитный быстрый вывод без комиссии. Популярные провайдеры: Endorphina, Betsoft, Pragmatic Play, Bgaming, Novomatic, NetEnt, Igrosoft, Belatra.',
                'rating' => 5.0,
                'min_deposit' => 100,
                'license' => 'Лицензия Кюрасао',
                'games_count' => 7500,
                'providers_count' => 40,
                'payment_methods' => ['СБП', 'Mastercard', 'Ethereum', 'Мир', 'Bitcoin', 'Visa', 'Dogecoin', 'Ripple'],
                'currencies' => ['RUB', 'USD', 'EUR', 'BTC', 'ETH', 'DOGE'],
                'languages' => ['ru', 'en'],
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Lex Casino - 7500 слотов с высоким RTP',
                'meta_description' => 'Lex Casino предлагает 7500 слотов с высоким RTP. Безлимитный быстрый вывод без комиссии.',
            ],
            [
                'name' => 'Play Fortuna',
                'slug' => 'play-fortuna',
                'description' => 'Интерфейс на русском языке, большой выбор софта и провайдеров, поддержка транзакций в фиатной и цифровой валюте. Популярные провайдеры: Endorphina, Betsoft, Pragmatic Play, Bgaming, Novomatic, NetEnt, Belatra, 1x2 Gaming.',
                'rating' => 4.9,
                'min_deposit' => 100,
                'license' => 'Лицензия Кюрасао',
                'games_count' => 3000,
                'providers_count' => 35,
                'payment_methods' => ['СБП', 'Mastercard', 'Ethereum', 'Мир', 'Bitcoin', 'Visa', 'Dash', 'Dogecoin'],
                'currencies' => ['RUB', 'USD', 'EUR', 'BTC', 'ETH'],
                'languages' => ['ru', 'en'],
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Play Fortuna - Казино с русским интерфейсом',
                'meta_description' => 'Play Fortuna предлагает интерфейс на русском языке и большой выбор игр. Поддержка фиатных и криптовалют.',
            ],
            [
                'name' => 'Cat Casino',
                'slug' => 'cat-casino',
                'description' => 'Оригинальный софт и провайдеры, большое количество развлечений, действующая лицензия Кюрасао. Популярные провайдеры: Endorphina, Betsoft, Pragmatic Play, Bgaming, Novomatic, NetEnt, Igrosoft, Belatra.',
                'rating' => 4.9,
                'min_deposit' => 100,
                'license' => 'Лицензия Кюрасао',
                'games_count' => 2500,
                'providers_count' => 30,
                'payment_methods' => ['СБП', 'Mastercard', 'Ethereum', 'Мир', 'Bitcoin', 'Visa', 'Tron', 'Litecoin'],
                'currencies' => ['RUB', 'USD', 'EUR', 'BTC', 'ETH'],
                'languages' => ['ru', 'en'],
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Cat Casino - Оригинальные игры и провайдеры',
                'meta_description' => 'Cat Casino предлагает оригинальный софт и большое количество развлечений. Действующая лицензия Кюрасао.',
            ],
            [
                'name' => 'Bitzamo Casino',
                'slug' => 'bitzamo-casino',
                'description' => 'Лицензия Кюрасао, пополнение баланса и вывод криптовалютами, большой ассортимент лайв-трансляций. Популярные провайдеры: Endorphina, Betsoft, Pragmatic Play, Bgaming, Novomatic, NetEnt, Igrosoft, Belatra.',
                'rating' => 4.9,
                'min_deposit' => 100,
                'license' => 'Лицензия Кюрасао',
                'games_count' => 2000,
                'providers_count' => 28,
                'payment_methods' => ['СБП', 'Mastercard', 'Ethereum', 'Мир', 'Bitcoin', 'Visa', 'ЮMoney', 'Dash'],
                'currencies' => ['RUB', 'USD', 'EUR', 'BTC', 'ETH'],
                'languages' => ['ru', 'en'],
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Bitzamo Casino - Криптоказино с лайв-играми',
                'meta_description' => 'Bitzamo Casino поддерживает криптовалюты и предлагает большой ассортимент лайв-трансляций.',
            ],
            [
                'name' => 'Jetton Games',
                'slug' => 'jetton-games',
                'description' => 'Казино скоро получит лицензию Кюрасао, регистрация с помощью Telegram, в турнирах разыгрываются деньги и другие призы. Популярные провайдеры: Endorphina, Betsoft, Pragmatic Play, Bgaming, NetEnt, Igrosoft, Belatra, Amatic.',
                'rating' => 4.9,
                'min_deposit' => 100,
                'license' => 'Скоро получит лицензию Кюрасао',
                'games_count' => 1500,
                'providers_count' => 25,
                'payment_methods' => ['СБП', 'Mastercard', 'Ethereum', 'Мир', 'Bitcoin', 'Visa', 'Tron', 'Litecoin'],
                'currencies' => ['RUB', 'USD', 'EUR', 'BTC', 'ETH'],
                'languages' => ['ru', 'en'],
                'is_featured' => false,
                'is_active' => true,
                'meta_title' => 'Jetton Games - Казино с регистрацией через Telegram',
                'meta_description' => 'Jetton Games предлагает регистрацию через Telegram и турниры с денежными призами.',
            ],
            [
                'name' => 'Bitz Casino',
                'slug' => 'bitz-casino',
                'description' => 'Подтвержденная лицензия от регулятора Кюрасао, приветственный бонус при первом пополнении, бездепозитные бонусы за продвижение по уровням лояльности. Популярные провайдеры: Endorphina, Pragmatic Play, Bgaming, NetEnt, Igrosoft, Belatra, Amatic, Yggdrasil Gaming.',
                'rating' => 4.9,
                'min_deposit' => 100,
                'license' => 'Лицензия Кюрасао',
                'games_count' => 1800,
                'providers_count' => 30,
                'payment_methods' => ['СБП', 'Mastercard', 'Ethereum', 'Мир', 'Bitcoin', 'Visa', 'Dogecoin', 'Tron'],
                'currencies' => ['RUB', 'USD', 'EUR', 'BTC', 'ETH'],
                'languages' => ['ru', 'en'],
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Bitz Casino - Казино с системой лояльности',
                'meta_description' => 'Bitz Casino предлагает бездепозитные бонусы за продвижение по уровням лояльности.',
            ],
            [
                'name' => 'Pinco Casino',
                'slug' => 'pinco-casino',
                'description' => 'Много азартных развлечений, сайт на русском языке, регистрация для игроков из России. Популярные провайдеры: Endorphina, Betsoft, Pragmatic Play, Bgaming, Novomatic, NetEnt, Igrosoft, Belatra.',
                'rating' => 4.9,
                'min_deposit' => 100,
                'license' => 'Лицензия Кюрасао',
                'games_count' => 2000,
                'providers_count' => 30,
                'payment_methods' => ['СБП', 'Mastercard', 'Ethereum', 'Мир', 'Bitcoin', 'Visa', 'Dogecoin', 'Tron'],
                'currencies' => ['RUB', 'USD', 'EUR', 'BTC', 'ETH'],
                'languages' => ['ru', 'en'],
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Pinco Casino - Казино для игроков из России',
                'meta_description' => 'Pinco Casino предлагает сайт на русском языке и регистрацию для игроков из России.',
            ],
            [
                'name' => 'Tip Top Casino',
                'slug' => 'tip-top-casino',
                'description' => 'Каталог содержит около 9000 азартных игр, есть подтвержденная лицензия, новичкам выдаются 3 приветственных бонуса. Популярные провайдеры: Endorphina, Betsoft, Pragmatic Play, Bgaming, Novomatic, NetEnt, Igrosoft, Belatra.',
                'rating' => 4.9,
                'min_deposit' => 100,
                'license' => 'Подтвержденная лицензия',
                'games_count' => 9000,
                'providers_count' => 45,
                'payment_methods' => ['СБП', 'Mastercard', 'Мир', 'Bitcoin', 'Visa', 'Piastrix', 'Tether', 'Сбербанк'],
                'currencies' => ['RUB', 'USD', 'EUR', 'BTC', 'ETH'],
                'languages' => ['ru', 'en'],
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Tip Top Casino - 9000 азартных игр',
                'meta_description' => 'Tip Top Casino предлагает около 9000 азартных игр и 3 приветственных бонуса для новичков.',
            ],
            [
                'name' => 'Joycasino',
                'slug' => 'joycasino',
                'description' => 'Подтвержденная лицензия от регулятора Кюрасао, бонусы для начинающих и постоянных посетителей, полноценная букмекерская площадка со ставками на спорт. Популярные провайдеры: Endorphina, Betsoft, Pragmatic Play, Bgaming, Novomatic, NetEnt, Igrosoft, Belatra.',
                'rating' => 4.8,
                'min_deposit' => 100,
                'license' => 'Лицензия Кюрасао',
                'games_count' => 2500,
                'providers_count' => 35,
                'payment_methods' => ['СБП', 'Mastercard', 'Ethereum', 'Мир', 'Bitcoin', 'Visa', 'Dogecoin', 'Ripple'],
                'currencies' => ['RUB', 'USD', 'EUR', 'BTC', 'ETH'],
                'languages' => ['ru', 'en'],
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Joycasino - Казино и букмекерская площадка',
                'meta_description' => 'Joycasino предлагает полноценную букмекерскую площадку со ставками на спорт.',
            ],
            [
                'name' => 'Riobet',
                'slug' => 'riobet',
                'description' => 'Большой выбор бонусов, наличие мобильной версии, саппорт общается на русском языке. Популярные провайдеры: Endorphina, Betsoft, Pragmatic Play, Bgaming, Novomatic, Booongo, NetEnt, Igrosoft.',
                'rating' => 4.8,
                'min_deposit' => 100,
                'license' => 'Лицензия Кюрасао',
                'games_count' => 2000,
                'providers_count' => 30,
                'payment_methods' => ['СБП', 'Мир', 'Visa', 'Payeer', 'ЮMoney', 'Tron', 'Piastrix'],
                'currencies' => ['RUB', 'USD', 'EUR'],
                'languages' => ['ru', 'en'],
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Riobet - Казино с русскоязычной поддержкой',
                'meta_description' => 'Riobet предлагает саппорт на русском языке и мобильную версию.',
            ],
            [
                'name' => 'Чемпион Слотс',
                'slug' => 'champion-slots',
                'description' => 'Большой выбор азартных развлечений, локализован на русском языке, использует криптовалюту. Популярные провайдеры: Endorphina, Betsoft, Pragmatic Play, Bgaming, Novomatic, NetEnt, Igrosoft, Belatra.',
                'rating' => 4.8,
                'min_deposit' => 100,
                'license' => 'Лицензия Кюрасао',
                'games_count' => 3000,
                'providers_count' => 35,
                'payment_methods' => ['СБП', 'Mastercard', 'Ethereum', 'Мир', 'Bitcoin', 'Visa', 'Ripple', 'Litecoin'],
                'currencies' => ['RUB', 'USD', 'EUR', 'BTC', 'ETH'],
                'languages' => ['ru', 'en'],
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Чемпион Слотс - Казино с криптовалютой',
                'meta_description' => 'Чемпион Слотс предлагает большой выбор игр и поддержку криптовалют.',
            ],
            [
                'name' => 'Селектор',
                'slug' => 'selektor',
                'description' => 'Наличие лицензии, сертифицированный софт, несколько бездепозитных бонусов, много платежных систем для пополнения баланса и выплат. Популярные провайдеры: Endorphina, Betsoft, Pragmatic Play, Bgaming, Novomatic, NetEnt, Igrosoft, Belatra.',
                'rating' => 4.8,
                'min_deposit' => 100,
                'license' => 'Лицензия Кюрасао',
                'games_count' => 2500,
                'providers_count' => 30,
                'payment_methods' => ['СБП', 'Mastercard', 'Ethereum', 'Мир', 'Bitcoin', 'Visa', 'ЮMoney', 'Dash'],
                'currencies' => ['RUB', 'USD', 'EUR', 'BTC', 'ETH'],
                'languages' => ['ru', 'en'],
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Селектор - Казино с бездепозитными бонусами',
                'meta_description' => 'Селектор предлагает несколько бездепозитных бонусов и много платежных систем.',
            ],
            [
                'name' => 'Casino Jet',
                'slug' => 'casino-jet',
                'description' => 'Работает по лицензии, богатый ассортимент игр, принимает криптовалюту. Популярные провайдеры: Endorphina, Betsoft, Pragmatic Play, Bgaming, Novomatic, NetEnt, Igrosoft, Belatra.',
                'rating' => 4.8,
                'min_deposit' => 100,
                'license' => 'Лицензия Кюрасао',
                'games_count' => 2000,
                'providers_count' => 30,
                'payment_methods' => ['СБП', 'Mastercard', 'Ethereum', 'Мир', 'Bitcoin', 'Visa', 'Dogecoin', 'Ripple'],
                'currencies' => ['RUB', 'USD', 'EUR', 'BTC', 'ETH'],
                'languages' => ['ru', 'en'],
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => 'Casino Jet - Казино с криптовалютой',
                'meta_description' => 'Casino Jet предлагает богатый ассортимент игр и поддержку криптовалют.',
            ],
            [
                'name' => '888starz',
                'slug' => '888starz',
                'description' => 'Популярное казино с большим выбором игр и бонусов. Поддерживает множество платежных методов и криптовалют.',
                'rating' => 4.7,
                'min_deposit' => 100,
                'license' => 'Лицензия Кюрасао',
                'games_count' => 3000,
                'providers_count' => 40,
                'payment_methods' => ['СБП', 'Mastercard', 'Visa', 'Bitcoin', 'Ethereum'],
                'currencies' => ['RUB', 'USD', 'EUR', 'BTC', 'ETH'],
                'languages' => ['ru', 'en'],
                'is_featured' => true,
                'is_active' => true,
                'meta_title' => '888starz - Популярное казино',
                'meta_description' => '888starz предлагает большой выбор игр и бонусов.',
            ],
        ];

        foreach ($casinos as $casino) {
            Casino::create($casino);
        }
    }
} 