<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ranks', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Название ранга (например, "Новичок", "Эксперт")
            $table->string('slug')->unique(); // Слаг для API
            $table->integer('min_points'); // Минимальное количество очков
            $table->integer('max_points'); // Максимальное количество очков
            $table->string('color', 7)->default('#6B7280'); // Цвет ранга (hex)
            $table->string('icon')->nullable(); // Иконка ранга
            $table->text('description')->nullable(); // Описание ранга
            $table->integer('level')->unique(); // Уровень ранга (1-10)
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ranks');
    }
};
