<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('slots', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->unique();
            $table->text('description')->nullable();
            $table->string('provider')->nullable();
            $table->string('theme')->nullable();
            $table->decimal('rtp', 5, 2)->nullable();
            $table->decimal('volatility', 3, 1)->nullable();
            $table->integer('min_bet')->nullable();
            $table->integer('max_bet')->nullable();
            $table->integer('max_win')->nullable();
            $table->integer('paylines')->nullable();
            $table->integer('reels')->nullable();
            $table->string('release_date')->nullable();
            $table->decimal('rating', 3, 2)->default(0.00);
            $table->integer('plays_count')->default(0);
            $table->json('features')->nullable();
            $table->json('bonus_features')->nullable();
            $table->string('demo_url')->nullable();
            $table->string('real_url')->nullable();
            $table->string('iframe_url')->nullable();
            $table->string('image')->nullable();
            $table->boolean('is_featured')->default(false);
            $table->boolean('is_active')->default(true);
            $table->string('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->text('meta_keywords')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('slots');
    }
};
