<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('casinos', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->unique();
            $table->text('description')->nullable();
            $table->string('logo')->nullable();
            $table->string('website')->nullable();
            $table->decimal('rating', 3, 2)->default(0.00);
            $table->decimal('min_deposit', 10, 2)->nullable();
            $table->decimal('max_deposit', 10, 2)->nullable();
            $table->decimal('min_withdrawal', 10, 2)->nullable();
            $table->decimal('max_withdrawal', 10, 2)->nullable();
            $table->string('withdrawal_time')->nullable();
            $table->string('license')->nullable();
            $table->integer('founded_year')->nullable();
            $table->string('headquarters')->nullable();
            $table->json('languages')->nullable();
            $table->json('currencies')->nullable();
            $table->json('payment_methods')->nullable();
            $table->integer('games_count')->default(0);
            $table->integer('providers_count')->default(0);
            $table->boolean('is_featured')->default(false);
            $table->boolean('is_active')->default(true);
            $table->string('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->text('meta_keywords')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('casinos');
    }
}; 