<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('parsed_posts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('parser_job_id')->constrained()->onDelete('cascade');
            $table->string('title'); // Заголовок поста
            $table->longText('content'); // Содержимое поста
            $table->string('original_url')->nullable(); // Оригинальная ссылка на пост
            $table->string('image_path')->nullable(); // Путь к сохраненному изображению
            $table->string('image_url')->nullable(); // Оригинальная ссылка на изображение
            $table->integer('page_number'); // Номер страницы, с которой взят пост
            $table->json('metadata')->nullable(); // Дополнительные метаданные
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('parsed_posts');
    }
};
