<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('parser_jobs', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Название задачи парсинга
            $table->text('base_url'); // Базовый URL для парсинга
            $table->string('pagination_pattern')->nullable(); // Шаблон пагинации (например, /page/{page})
            $table->integer('start_page')->default(1); // Начальная страница
            $table->integer('end_page')->default(1); // Конечная страница
            $table->string('post_selector'); // CSS селектор для постов
            $table->string('title_selector'); // CSS селектор для заголовков
            $table->string('content_selector'); // CSS селектор для контента
            $table->string('image_selector')->nullable(); // CSS селектор для изображений
            $table->string('link_selector')->nullable(); // CSS селектор для ссылок
            $table->enum('status', ['pending', 'running', 'completed', 'failed'])->default('pending');
            $table->text('error_message')->nullable(); // Сообщение об ошибке
            $table->integer('total_posts')->default(0); // Общее количество найденных постов
            $table->integer('parsed_posts')->default(0); // Количество обработанных постов
            $table->json('settings')->nullable(); // Дополнительные настройки
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('parser_jobs');
    }
};
