<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Console\Commands\Dev;
use App\Console\Commands\Prod;
use App\Console\Commands\ServeSimple;
use App\Console\Commands\RetroactivePointsGrant;

class CommandServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                Dev::class,
                Prod::class,
                ServeSimple::class,
                RetroactivePointsGrant::class,
            ]);
        }
    }
} 