<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class StoryLike extends Model
{
    use HasFactory;

    protected $fillable = [
        'story_id',
        'user_id'
    ];

    /**
     * Get the story that was liked.
     */
    public function story(): BelongsTo
    {
        return $this->belongsTo(Story::class);
    }

    /**
     * Get the user who liked the story.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
