<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class ParsedPost extends Model
{
    protected $fillable = [
        'parser_job_id',
        'title',
        'content',
        'original_url',
        'image_path',
        'image_url',
        'page_number',
        'metadata'
    ];

    protected $casts = [
        'metadata' => 'array',
        'page_number' => 'integer'
    ];

    /**
     * Отношение к задаче парсинга
     */
    public function parserJob(): BelongsTo
    {
        return $this->belongsTo(ParserJob::class);
    }

    /**
     * Получить полный URL изображения
     */
    public function getImageUrlAttribute($value): ?string
    {
        if ($this->image_path && !$value) {
            return Storage::disk('public')->url($this->image_path);
        }
        
        return $value;
    }

    /**
     * Получить сокращенный контент для предпросмотра
     */
    public function getExcerptAttribute(): string
    {
        return Str::limit(strip_tags($this->content), 200);
    }
}
