<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class NewsLike extends Model
{
    use HasFactory;

    protected $fillable = [
        'news_id',
        'user_id',
        'type',
    ];

    /**
     * Новость, к которой относится лайк
     */
    public function news(): BelongsTo
    {
        return $this->belongsTo(News::class);
    }

    /**
     * Пользователь, который поставил лайк
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
