<?php

namespace App\Jobs;

use App\Models\ParserJob;
use App\Services\ParserService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ParseContentJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $timeout = 3600; // 1 час
    public $tries = 1;

    protected $parserJob;

    /**
     * Create a new job instance.
     */
    public function __construct(ParserJob $parserJob)
    {
        $this->parserJob = $parserJob;
    }

    /**
     * Execute the job.
     */
    public function handle(ParserService $parserService): void
    {
        $parserService->parse($this->parserJob);
    }

    /**
     * Handle a job failure.
     */
    public function failed(\Throwable $exception): void
    {
        $this->parserJob->update([
            'status' => 'failed',
            'error_message' => $exception->getMessage()
        ]);
    }
}
