<?php

namespace App\Http\Middleware;

use Illuminate\Auth\Middleware\Authenticate as Middleware;

class ApiAuthenticate extends Middleware
{
    protected function redirectTo($request)
    {
        // Для API всегда возвращаем null, чтобы не было редиректа
        if ($request->expectsJson() || $request->is('api/*')) {
            \Log::info('🔐 ApiAuthenticate middleware', [
                'url' => $request->fullUrl(),
                'method' => $request->method(),
                'authorization_header' => $request->header('Authorization'),
                'bearer_token' => $request->bearerToken(),
                'expects_json' => $request->expectsJson(),
                'is_api' => $request->is('api/*'),
                'auth_check' => auth('sanctum')->check(),
                'user' => auth('sanctum')->user() ? auth('sanctum')->user()->id : 'null',
                'sanctum_guard' => auth('sanctum')->guardName(),
                'all_guards' => config('auth.guards'),
                'timestamp' => now()->toISOString()
            ]);
            return null;
        }
        // Для web — стандартное поведение
        return route('login');
    }
} 