<?php

namespace App\Http\Controllers;

use App\Models\Bookmaker;
use App\Models\Casino;
use App\Models\Slot;
use App\Models\Prediction;
use App\Models\User;
use App\Models\News;
use Illuminate\Http\Response;

class SitemapController extends Controller
{
    public function index()
    {
        $content = view('sitemap', [
            'bookmakers' => Bookmaker::all(),
            'predictions' => Prediction::where('status', 'active')->get(),
            'predictors' => User::where('role', 'predictor')->get(),
            'news' => News::where('status', 'published')->get(),
        ]);

        return response($content, 200)
            ->header('Content-Type', 'application/xml');
    }
} 