<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Laravel\Socialite\Facades\Socialite;
use Illuminate\Support\Str;

class GoogleAuthController extends Controller
{
    /**
     * Redirect to Google OAuth
     */
    public function redirectToGoogle()
    {
        return Socialite::driver('google')->redirect();
    }

    /**
     * Handle Google OAuth callback
     */
    public function handleGoogleCallback(Request $request)
    {
        try {
            $googleUser = Socialite::driver('google')->user();

            // Находим или создаем пользователя
            $user = User::where('email', $googleUser->email)->first();

            if (!$user) {
                // Создаем нового пользователя
                $user = User::create([
                    'name' => $googleUser->name,
                    'email' => $googleUser->email,
                    'username' => $this->generateUniqueUsername($googleUser->name),
                    'password' => Hash::make(Str::random(16)), // Случайный пароль
                    'referral_code' => User::generateReferralCode(),
                    'email_verified_at' => now(), // Google email уже верифицирован
                    'google_id' => $googleUser->id,
                ]);
            } else {
                // Обновляем существующего пользователя
                $user->update([
                    'google_id' => $googleUser->id,
                    'name' => $googleUser->name,
                    'email_verified_at' => now(),
                ]);
            }

            // Создаем токен
            $token = $user->createToken('google_auth_token')->plainTextToken;

            // Подготавливаем данные пользователя
            $userData = $user->toArray();
            $userData['avatar_url'] = $user->getAvatarUrl();

            // Перенаправляем на фронтенд с токеном
            $redirectUrl = 'http://localhost:8000/login?google_success=1&token=' . $token . '&user=' . urlencode(json_encode($userData));
            
            return redirect($redirectUrl);

        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Ошибка аутентификации через Google: ' . $e->getMessage()
            ], 500);
        }
    }

    /**
     * Generate unique username from name
     */
    private function generateUniqueUsername($name)
    {
        $baseUsername = Str::slug($name);
        $username = $baseUsername;
        $counter = 1;

        while (User::where('username', $username)->exists()) {
            $username = $baseUsername . '_' . $counter;
            $counter++;
        }

        return $username;
    }
} 