<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Symfony\Component\Process\Process;

class Prod extends Command
{
    protected $signature = 'prod {--port=8000} {--host=0.0.0.0}';
    protected $description = 'Запуск production сервера (собранные assets)';

    public function handle()
    {
        $port = $this->option('port');
        $host = $this->option('host');

        $this->info('🚀 Запуск production сервера...');
        $this->info("📡 Laravel: http://{$host}:{$port}");
        $this->info('');

        // Проверяем собранные assets
        if (!file_exists(public_path('build/manifest.json'))) {
            $this->error('❌ Production assets не найдены!');
            $this->info('💡 Соберите assets командой: npm run build');
            return 1;
        }

        $this->info('✅ Production assets найдены');
        $this->info('🔄 Запуск Laravel сервера...');

        // Запускаем Laravel сервер
        $laravelProcess = new Process(['php', 'artisan', 'serve', '--host=' . $host, '--port=' . $port]);
        $laravelProcess->setTty(true);
        $laravelProcess->run();

        return 0;
    }
} 