<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Prediction;
use App\Models\PredictionLike;

class FixPredictionLikes extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'predictions:fix-likes';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Fix prediction likes count by recalculating from actual likes table';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Checking prediction likes count...');
        
        $predictions = Prediction::all();
        $fixedCount = 0;
        
        foreach ($predictions as $prediction) {
            $actualLikesCount = PredictionLike::where('prediction_id', $prediction->id)->count();
            $storedLikesCount = $prediction->likes_count;
            
            if ($actualLikesCount !== $storedLikesCount) {
                $this->warn("Prediction ID {$prediction->id}: stored={$storedLikesCount}, actual={$actualLikesCount}");
                
                $prediction->likes_count = $actualLikesCount;
                $prediction->save();
                $fixedCount++;
            }
        }
        
        $this->info("Fixed {$fixedCount} predictions with incorrect likes count.");
        
        // Show some examples
        $this->info("\nSample predictions with their likes count:");
        $samplePredictions = Prediction::take(5)->get();
        foreach ($samplePredictions as $prediction) {
            $this->line("ID: {$prediction->id}, Likes: {$prediction->likes_count}, Teams: {$prediction->home_team} vs {$prediction->away_team}");
        }
    }
} 