<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class CreateTestToken extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'test:token {user_id=1}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create a test token for user';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $userId = $this->argument('user_id');
        
        $user = User::find($userId);
        
        if (!$user) {
            $this->error("User with ID {$userId} not found!");
            return 1;
        }
        
        // Создаем токен
        $token = $user->createToken('test-token')->plainTextToken;
        
        $this->info("Test token created for user: {$user->username}");
        $this->info("Token: {$token}");
        $this->info("User ID: {$user->id}");
        
        return 0;
    }
} 