<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use App\Models\Prediction;

class CleanupOnlineStatus extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:cleanup-online-status';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Cleanup online status for inactive users';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        // Обновляем статистику пользователей
        $this->info('Обновление статистики пользователей...');
        
        $users = User::all();
        $updatedCount = 0;
        
        foreach ($users as $user) {
            $predictionsCount = $user->predictions()->count();
            $correctPredictions = $user->predictions()->where('status', 'won')->count();
            $successRate = $predictionsCount > 0 ? round(($correctPredictions / $predictionsCount) * 100, 2) : 0;
            
            $user->update([
                'predictions_count' => $predictionsCount,
                'correct_predictions' => $correctPredictions,
                'success_rate' => $successRate,
            ]);
            
            $updatedCount++;
        }
        
        $this->info("Обновлена статистика для {$updatedCount} пользователей");
        
        // Очищаем онлайн статус для неактивных пользователей
        $this->info('Очистка онлайн статуса...');
        
        $inactiveUsers = User::where('is_online', true)
            ->where('last_activity_at', '<', now()->subMinutes(5))
            ->update(['is_online' => false]);
            
        $this->info("Очищен онлайн статус для {$inactiveUsers} пользователей");
        
        return Command::SUCCESS;
    }
}
