# 🚀 Laravel Artisan для мобильного доступа

## 📱 Быстрый запуск

### Только Laravel сервер:
```powershell
.\start-mobile.ps1
```

### Все серверы (Laravel + Vite + Soketi):
```powershell
.\start-all.ps1
```

## 🔧 Ручной запуск через Artisan

### Laravel сервер для всех в сети:
```bash
php artisan serve --host=0.0.0.0 --port=8000
```

### С другим портом:
```bash
php artisan serve --host=0.0.0.0 --port=8080
```

## 🌐 Доступ

После запуска:
1. **Скопируйте IP адрес** (показывается в консоли)
2. **В телефоне введите:** `http://[IP]:8000`
3. **Убедитесь что телефон в той же WiFi сети**

## 🔍 Параметры команды

- `--host=0.0.0.0` - слушать на всех интерфейсах
- `--port=8000` - порт (по умолчанию 8000)
- `--host=127.0.0.1` - только localhost (по умолчанию)

## ⚠️ Безопасность

- Доступ только в пределах вашей сети
- Для публичного доступа используйте ngrok
- Не используйте в продакшене

## 🛠️ Диагностика

### Проверка портов:
```powershell
netstat -an | findstr :8000
```

### Проверка файрвола:
```powershell
netsh advfirewall firewall show rule name=all | findstr "8000"
```

### Разрешить порт в файрволе:
```powershell
netsh advfirewall firewall add rule name="Laravel Dev" dir=in action=allow protocol=TCP localport=8000
``` 