# 🚀 Быстрый старт

## Установка

```bash
# 1. Зависимости
composer install
npm install

# 2. Окружение
cp .env.example .env
php artisan key:generate

# 3. База данных
php artisan migrate --seed
```

## Запуск

### 🛠️ Разработка
```bash
# Запуск Laravel + Vite
php artisan dev

# С другим портом
php artisan dev --port=8080
```

### 🚀 Production
```bash
# Сборка assets
npm run build

# Запуск production сервера
php artisan prod

# С настройками
php artisan prod --port=8080 --host=127.0.0.1
```

### 📡 Только Laravel
```bash
# Без Vite (для API)
php artisan serve:simple
```

## Тестовые аккаунты

**Админ:**
- Email: admin@example.com
- Пароль: password

**Пользователь:**
- Email: user@example.com
- Пароль: password

## Полезные команды

```bash
# База данных
php artisan migrate:fresh --seed  # Сброс + данные

# Кэш
php artisan config:clear
php artisan cache:clear

# Assets
npm run build                     # Production сборка
npm run dev                       # Development режим
```

## Структура

```
├── app/Console/Commands/         # Команды
│   ├── Dev.php                  # Разработка
│   ├── Prod.php                 # Production
│   └── ServeSimple.php          # Только Laravel
├── resources/js/                # Vue.js
└── routes/api.php              # API маршруты
```

## 🛑 Остановка
```bash
# Windows
stop-servers.bat

# Или Ctrl+C в каждом окне
```

---

## ✅ Что работает:
- ✅ Регистрация и авторизация
- ✅ Профиль пользователя
- ✅ Промокоды и букмекеры
- ✅ Предсказания
- ✅ Мессенджер (без real-time)
- ✅ Админ панель

## ❌ Что отключено:
- ❌ WebSocket (real-time чат)
- ❌ Сложные команды запуска
- ❌ Сетевой доступ по умолчанию

---

## 🔧 Если что-то не работает:

### Проблема: "Composer не найден"
**Решение:** https://getcomposer.org/

### Проблема: "Node.js не найден"
**Решение:** https://nodejs.org/

### Проблема: "PHP не найден"
**Решение:** https://php.net/

### Проблема: "Порт занят"
**Решение:** 
```bash
php artisan serve:simple --port=8080 --vite
```

### Проблема: "База данных недоступна"
**Решение:**
```bash
touch database/database.sqlite
php artisan migrate:fresh --seed
```

---

## 📞 Поддержка
1. Проверьте версии: PHP 8.2+, Node.js 16+
2. Убедитесь что все зависимости установлены
3. Проверьте настройки в .env файле
4. Посмотрите логи: `storage/logs/laravel.log`

**Нужна помощь?** Создайте issue в репозитории. 